// DriverSettings1.cpp : implementation file
//

#include "stdafx.h"
#include "Ultima_C++Demo.h"
#include "MainSheet.h"
#include "DriverSettings1.h"
#include "DriverSettings2.h"
#include "afxdialogex.h"

//#############################################################################

// CDriverSettings1 dialog
IMPLEMENT_DYNAMIC(CDriverSettings1, CPropertyPage)

CDriverSettings1::CDriverSettings1()
	: CPropertyPage(CDriverSettings1::IDD)
	, DvrAction(0)
{
	Initialised = FALSE;
}

CDriverSettings1::~CDriverSettings1()
{
}

void CDriverSettings1::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_DRIVERBOX, Driver1Msg);
	DDX_Radio(pDX, IDC_GETACTIONRADIO_D1, DvrAction);
	DDV_MinMaxInt(pDX, DvrAction, 0, 1);
	DDX_Control(pDX, IDC_COLOURCORRECTION_COMBO, ColourCorrection);
	DDX_Control(pDX, IDC_SHARPNESS, Sharpness);
	DDX_Control(pDX, IDC_SHARPNESS_SPIN, Sharpness_Spin);
	DDX_Control(pDX, IDC_YMC_POWER, YMCPower);
	DDX_Control(pDX, IDC_YMC_POWER_SPIN, YMCPower_Spin);
	DDX_Control(pDX, IDC_K_POWER, KPower);
	DDX_Control(pDX, IDC_K_POWER_SPIN, KPower_Spin);
	DDX_Control(pDX, IDC_O_POWER, OPower);
	DDX_Control(pDX, IDC_O_POWER_SPIN, OPower_Spin);
	DDX_Control(pDX, IDC_RESINAREA_NO, ResinArea_No);
	DDX_Control(pDX, IDC_RESINAREA_NO_SPIN, ResinArea_No_Spin);
	DDX_Control(pDX, IDC_RESINAREA_SIDE, ResinArea_Side);
	DDX_Control(pDX, IDC_RESINAREA_LEFT, ResinArea_Left);
	DDX_Control(pDX, IDC_RESINAREA_LEFT_SPIN, ResinArea_Left_Spin);
	DDX_Control(pDX, IDC_RESINAREA_WIDTH, ResinArea_Width);
	DDX_Control(pDX, IDC_RESINAREA_WIDTH_SPIN, ResinArea_Width_Spin);
	DDX_Control(pDX, IDC_RESINAREA_BOTTOM, ResinArea_Bottom);
	DDX_Control(pDX, IDC_RESINAREA_BOTTOM_SPIN, ResinArea_Bottom_Spin);
	DDX_Control(pDX, IDC_RESINAREA_HEIGHT, ResinArea_Height);
	DDX_Control(pDX, IDC_RESINAREA_HEIGHT_SPIN, ResinArea_Height_Spin);
	DDX_Control(pDX, IDC_GUIUSER, GUIUser);
	DDX_Control(pDX, IDC_GUIPRINTER, GUIPrinter);
}

BEGIN_MESSAGE_MAP(CDriverSettings1, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_DRIVERBOXCLEAR, &CDriverSettings1::OnBnClickedBtnDriverboxclear)
	ON_BN_CLICKED(IDC_BTN_GUICONTROL, &CDriverSettings1::OnBnClickedBtnGUIcontrol)
	ON_BN_CLICKED(IDC_BTN_SHARPNESS, &CDriverSettings1::OnBnClickedBtnSharpness)
	ON_BN_CLICKED(IDC_BTN_COLOURCORRECTION, &CDriverSettings1::OnBnClickedBtnColourcorrection)
	ON_BN_CLICKED(IDC_BTN_POWERLEVEL, &CDriverSettings1::OnBnClickedBtnPowerlevel)
	ON_BN_CLICKED(IDC_BTN_RESINAREA, &CDriverSettings1::OnBnClickedBtnResinarea)
	ON_BN_CLICKED(IDC_SETACTIONRADIO_D1, &CDriverSettings1::OnBnClickedSetActionRadio)
	ON_BN_CLICKED(IDC_GETACTIONRADIO_D1, &CDriverSettings1::OnBnClickedGetActionRadio)
	ON_CBN_SELCHANGE(IDC_RESINAREA_SIDE, &CDriverSettings1::OnCbnSelchangeResinArea)
	ON_EN_CHANGE(IDC_RESINAREA_NO, &CDriverSettings1::OnEnChangeResinareaNo)
END_MESSAGE_MAP()

//#############################################################################

// CDriverSettings1 message handlers
BOOL CDriverSettings1::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	Parent = (CMainSheet *)GetParent();

	//Initialise the Controls on the Property Page...
	//...GUIControl
	ID_GUICONTROL GUICtrl;
	GetGUIControl(&GUICtrl);
	SetGUIControl(&GUICtrl);

	//...Sharpness
	signed char temp;
	Sharpness_Spin.SetRange(-2, +2);
	GetSharpness(&temp);

	//...Colour Correction
	COLCORRECT ColCorrect;
	GetColourCorrection(&ColCorrect);

	//...Power Level
	POWERLEVEL PowerLevel;
	YMCPower_Spin.SetRange(0, 100);
	KPower_Spin.SetRange(0, 100);
	OPower_Spin.SetRange(0, 100);
	GetPowerLevels(&PowerLevel);

	//...Resin Area
	AREA Area;
	ResinArea_Side.SetCurSel(0);
	ResinArea_No.SetWindowText(_T("1"));
	ResinArea_No_Spin.SetRange(1, 10);
	ResinArea_Left_Spin.SetRange(0, Parent->MaxXCoord());
	ResinArea_Width_Spin.SetRange(0, Parent->MaxCardWidth());
	ResinArea_Bottom_Spin.SetRange(0, Parent->MaxYCoord());
	ResinArea_Height_Spin.SetRange(0, Parent->MaxCardHeight());
	GetResinArea(ID_SIDE_FRONT, 1, &Area);

	Initialised = TRUE;
	EnableGetSetControls(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//****************************************************************************

void CDriverSettings1::EnableGetSetControls
(
	BOOL bControl
)
{
	GUIUser.EnableWindow(bControl);
	GUIPrinter.EnableWindow(bControl);
	Sharpness.EnableWindow(bControl);
	Sharpness_Spin.EnableWindow(bControl);
	ColourCorrection.EnableWindow(bControl);

	YMCPower.EnableWindow(bControl);
	KPower.EnableWindow(bControl);
	OPower.EnableWindow(bControl);
	YMCPower_Spin.EnableWindow(bControl);
	KPower_Spin.EnableWindow(bControl);
	OPower_Spin.EnableWindow(bControl);

	ResinArea_Left.EnableWindow(bControl);
	ResinArea_Width.EnableWindow(bControl);
	ResinArea_Bottom.EnableWindow(bControl);
	ResinArea_Height.EnableWindow(bControl);
	ResinArea_Left_Spin.EnableWindow(bControl);
	ResinArea_Width_Spin.EnableWindow(bControl);
	ResinArea_Bottom_Spin.EnableWindow(bControl);
	ResinArea_Height_Spin.EnableWindow(bControl);
}

void CDriverSettings1::OnBnClickedGetActionRadio()
{
	EnableGetSetControls(FALSE);
}

void CDriverSettings1::OnBnClickedSetActionRadio()
{
	EnableGetSetControls(TRUE);
}

void CDriverSettings1::OnBnClickedBtnDriverboxclear()
{
	Driver1Msg.SetWindowText(_T(""));
}

BOOL CDriverSettings1::ActionIsGet()
{
	UpdateData();
	return (DvrAction == 0);
}

void CDriverSettings1::AddDriverMessage
(
	CString pMessage
)
{
	Parent->AddString(&Driver1Msg, pMessage);
}

//#############################################################################

void CDriverSettings1::GUIControlToMsgBox
(
	PID_GUICONTROL pControl,
	ID_READWRITE   Action
)
{
	//Update the message box with GUI control status
	CString sep = Parent->Separator(Action);
	AddDriverMessage(_T("GUI User")    + sep + Parent->EnabledDisabledString(pControl->GUIUser));
	AddDriverMessage(_T("GUI Printer") + sep + Parent->EnabledDisabledString(pControl->GUIPrinter));
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetGUIControl
(
	PID_GUICONTROL pControl
)
{
	//Update the GUI control display objects
	GUIUser.SetCheck(pControl->GUIUser);
	GUIPrinter.SetCheck(pControl->GUIPrinter);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetGUIControl
(
	PID_GUICONTROL pControl
)
{
	ID_RETURN result = ID_ERROR;

	//Get SDK function address
	PFNIDGUICONTROL pFnGUIControl = (PFNIDGUICONTROL)GetProcAddress(Parent->hLib, "ID_GUIControl");
	if (!pFnGUIControl)
	{
		FUNCTION_NOT_ACCESSED(GetGUIControl);
	}

	else
	{
		//Call SDK to read the GUI User setting
		ID_RETURN SDKReturn = (*pFnGUIControl)(Parent->hSession, ID_READ, pControl);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(GetGUIControl, SDKReturn);
		}
		else
		{
			result = ID_SUCCESS;
		}
	}

	return result;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnGUIcontrol()
{
	CWaitCursor wait;
	ID_GUICONTROL Control;

	if (ActionIsGet())
	{
		//Get GUI control Setting
		if (GetGUIControl(&Control) == ID_SUCCESS)
		{
			//Update the display
			SetGUIControl(&Control);
			GUIControlToMsgBox(&Control, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDGUICONTROL pFnSetGUIControl = (PFNIDGUICONTROL)GetProcAddress(Parent->hLib, "ID_GUIControl");
		if (!pFnSetGUIControl)
		{
			FUNCTION_NOT_ACCESSED(SetGUIControl);
		}

		else
		{
			//Get GUI Control setting from control
			Control.GUIUser    = GUIUser.GetCheck();
			Control.GUIPrinter = GUIPrinter.GetCheck();

			//Call the SDK to write to the driver
			ID_RETURN SDKReturn = (*pFnSetGUIControl)(Parent->hSession, ID_WRITE, &Control);
			if (SDKReturn != ERROR_SUCCESS)
			{
				DISPLAY_ERROR(SetGUIControl, SDKReturn);
			}

			else
			{
				//Update the message box
				GUIControlToMsgBox(&Control, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::SetSharpness(int value)
{
	//Update the Sharpness control
	CString temp_string;
	temp_string.Format(_T("%d"), value);
	Sharpness.SetWindowText(temp_string);
}

//****************************************************************************

void CDriverSettings1::SharpnessToMsgBox
(
	signed char  Sharpness,
	ID_READWRITE Action
)
{
	//Update the messagebox with the Sharpness setting
	CString temp_string;
	temp_string.Format(_T("%d"), Sharpness);
	AddDriverMessage(_T("Sharpness") + Parent->Separator(Action) + temp_string);
	AddDriverMessage(_T(""));
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetSharpness
(
	signed char *pSharpness
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDSHARPNESS pFnSharpness = (PFNIDSHARPNESS)GetProcAddress(Parent->hLib, "ID_Sharpness");
	if (!pFnSharpness)
	{
		FUNCTION_NOT_ACCESSED(GetSharpness);
	}

	else
	{
		//Call SDK to read the Sharpness setting
		SDKReturn = (*pFnSharpness)(Parent->hSession, ID_READ, pSharpness);
		if (SDKReturn == ID_SUCCESS)
		{
			SetSharpness(*pSharpness);
		}
		else
		{
			DISPLAY_ERROR(GetSharpness, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnSharpness()
{
	CWaitCursor wait;
	CString temp_string;
	signed char value;

	if (ActionIsGet())
	{
		//Get Sharpness Setting
		if (GetSharpness(&value) == ID_SUCCESS)
		{
			//Update the display
			SharpnessToMsgBox(value, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDSHARPNESS pFnSetSharpness = (PFNIDSHARPNESS)GetProcAddress(Parent->hLib, "ID_Sharpness");
		if (!pFnSetSharpness)
		{
			FUNCTION_NOT_ACCESSED(Sharpness);
		}

		else
		{
			//Get Sharpness setting from control
			Sharpness.GetWindowText(temp_string);
			value = _ttoi(temp_string);

			//Call the SDK to update the driver
			ID_RETURN SDKReturn = (*pFnSetSharpness)(Parent->hSession, ID_WRITE, &value);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetSharpness, SDKReturn);
			}

			else
			{
				//Update the message box
				SharpnessToMsgBox(value, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::CorrectionToMsgBox
(
	COLCORRECT  Correction,
	ID_READWRITE Action
)
{
	//Update the message box with Colour Correction status
	AddDriverMessage(_T("Correction") + Parent->Separator(Action) + Parent->CorrectionString(Correction));
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetColourCorrection
(
	COLCORRECT Correction
)
{
	//Update the Colour Correction display
	ColourCorrection.SetCurSel(Correction);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetColourCorrection
(
	PCOLCORRECT pCorrection
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDCORRECTION pFnColourCorrection = (PFNIDCORRECTION)GetProcAddress(Parent->hLib, "ID_ColourCorrection");
	if (!pFnColourCorrection)
	{
		FUNCTION_NOT_ACCESSED(GetColourCorrection);
	}

	else
	{
		//Call SDK to read the Colour Correction setting
		SDKReturn = (*pFnColourCorrection)(Parent->hSession, ID_READ, pCorrection);
		if (SDKReturn == ID_SUCCESS)
		{
			SetColourCorrection(*pCorrection);
		}
		else
		{
			DISPLAY_ERROR(GetColourCorrection, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnColourcorrection()
{
	CWaitCursor	wait;
	COLCORRECT	Correction;

	if (ActionIsGet())
	{
		//Get Colour Correction Setting
		if (GetColourCorrection(&Correction) == ID_SUCCESS)
		{
			//Update the display
			CorrectionToMsgBox(Correction, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDCORRECTION pFnSetColourCorrection = (PFNIDCORRECTION)GetProcAddress(Parent->hLib, "ID_ColourCorrection");
		if (!pFnSetColourCorrection)
		{
			FUNCTION_NOT_ACCESSED(SetColourCorrection);
		}

		else
		{
			//Get Colour Correction setting from control
			Correction = (COLCORRECT)ColourCorrection.GetCurSel();

			//Call the SDK to update it in the driver
			int SDKReturn = (*pFnSetColourCorrection)(Parent->hSession, ID_WRITE, &Correction);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetColourCorrection, SDKReturn);
			}

			else
			{
				//Update the message box
				CorrectionToMsgBox(Correction, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::PowerLevelsToMsgBox
(
	POWERLEVEL PowerLevel,
	ID_READWRITE Action
)
{
	//Update the message box with the Power Levels
	CString temp_string;
	CString sep = Parent->Separator(Action);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.YMC);
	AddDriverMessage(_T("Power Level YMC") + sep + temp_string);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.Resin);
	AddDriverMessage(_T("Power Level Resin") + sep + temp_string);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.Overcoat);
	AddDriverMessage(_T("Power Level Overcoat") + sep + temp_string);
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetPowerLevels
(
	POWERLEVEL PowerLevel
)
{
	//Update the Power Levels controls
	CString temp_string;
	temp_string.Format(_T("%d"), (signed char)PowerLevel.YMC);
	YMCPower.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.Resin);
	KPower.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), (signed char)PowerLevel.Overcoat);
	OPower.SetWindowText(temp_string);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetPowerLevels
(
	PPOWERLEVEL pPowerLevel
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDPOWERLEVEL pFnPowerLevel = (PFNIDPOWERLEVEL)GetProcAddress(Parent->hLib, "ID_PowerLevel");
	if (!pFnPowerLevel)
	{
		FUNCTION_NOT_ACCESSED(GetPowerLevel);
	}

	else
	{
		//Call SDK to read the Power Level setting
		SDKReturn = (*pFnPowerLevel)(Parent->hSession, ID_READ, pPowerLevel);
		if (SDKReturn == ID_SUCCESS)
		{
			SetPowerLevels(*pPowerLevel);
		}
		else
		{
			DISPLAY_ERROR(GetPowerLevel, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnPowerlevel()
{
	POWERLEVEL PowerLevel = {};
	CWaitCursor wait;
	CString temp_string;

	if (ActionIsGet())
	{
		//Get Power Level Settings
		if (GetPowerLevels(&PowerLevel) == ID_SUCCESS)
		{
			//Update the display
			PowerLevelsToMsgBox(PowerLevel, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDPOWERLEVEL pFnSetPowerLevel = (PFNIDPOWERLEVEL)GetProcAddress(Parent->hLib, "ID_PowerLevel");
		if (!pFnSetPowerLevel)
		{
			FUNCTION_NOT_ACCESSED(SetPowerLevel);
		}

		else
		{
			//Get Power Level settings from controls
			YMCPower.GetWindowText(temp_string);
			PowerLevel.YMC = _ttoi(temp_string);
			KPower.GetWindowText(temp_string);
			PowerLevel.Resin = _ttoi(temp_string);
			OPower.GetWindowText(temp_string);
			PowerLevel.Overcoat = _ttoi(temp_string);

			//Write to the driver
			ID_RETURN SDKReturn = (*pFnSetPowerLevel)(Parent->hSession, ID_WRITE, &PowerLevel);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetPowerLevel, SDKReturn);
			}

			else
			{
				//Update the message box
				PowerLevelsToMsgBox(PowerLevel, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CDriverSettings1::OnCbnSelchangeResinArea()
{
	AREA Area = {0};
	CString temp_string;

	//Resin Area settings have been changed
	ResinArea_No.GetWindowText(temp_string);
	int AreaNo = _ttoi(temp_string);

	if (GetResinArea((ID_SIDE)ResinArea_Side.GetCurSel(), AreaNo, &Area) == ID_SUCCESS)
	{
		SetResinArea(&Area);
	}
}

//****************************************************************************

void CDriverSettings1::OnEnChangeResinareaNo()
{
	if (Initialised)
	{
		//Resin Area Number has been changed
		OnCbnSelchangeResinArea();
	}
}

//****************************************************************************

void CDriverSettings1::ResinAreaToMsgBox
(
	ID_SIDE      Side,
	int          AreaNo,
	PAREA        pArea,
	ID_READWRITE Action
)
{
	//Update the message box with the Resin Area settings
	CString temp_string;
	CString sep = Parent->Separator(Action);

	temp_string.Format(_T("Resin Area %s %d"), Parent->SideString(Side), AreaNo);
	AddDriverMessage(temp_string);
	temp_string.Format(_T("%d"), pArea->Left);
	AddDriverMessage(_T("Left") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Width);
	AddDriverMessage(_T("Width") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Bottom);
	AddDriverMessage(_T("Bottom") + sep + temp_string);
	temp_string.Format(_T("%d"), pArea->Height);
	AddDriverMessage(_T("Height") + sep + temp_string);
	AddDriverMessage(_T(""));
}

//****************************************************************************

void CDriverSettings1::SetResinArea(PAREA pArea)
{
	//Update the Resin Area controls
	CString temp_string;
	temp_string.Format(_T("%d"), pArea->Left);
	ResinArea_Left.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Width);
	ResinArea_Width.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Bottom);
	ResinArea_Bottom.SetWindowText(temp_string);
	temp_string.Format(_T("%d"), pArea->Height);
	ResinArea_Height.SetWindowText(temp_string);
}

//****************************************************************************

ID_RETURN CDriverSettings1::GetResinArea
(
	ID_SIDE Side,
	int		AreaNo,
	PAREA	pArea
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDRESINAREA pFnResinArea = (PFNIDRESINAREA)GetProcAddress(Parent->hLib, "ID_ResinArea");
	if (!pFnResinArea)
	{
		FUNCTION_NOT_ACCESSED(GetResinArea);
	}

	else
	{
		//Call SDK to read the Resin Area setting
		SDKReturn = (*pFnResinArea)(Parent->hSession, ID_READ, Side, AreaNo, pArea);
		if (SDKReturn == ID_SUCCESS)
		{
			SetResinArea(pArea);
		}
		else
		{
			DISPLAY_ERROR(GetResinArea, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CDriverSettings1::OnBnClickedBtnResinarea()
{
	AREA Area = {0};
	CWaitCursor wait;
	CString temp_string;

	ResinArea_No.GetWindowText(temp_string);
	int AreaNo = _ttoi(temp_string);
	ID_SIDE Side = (ID_SIDE)ResinArea_Side.GetCurSel();

	if (ActionIsGet())
	{
		//Get the Resin Area settings
		if (GetResinArea(Side, AreaNo, &Area) == ID_SUCCESS)
		{
			//Update the display
			ResinAreaToMsgBox(Side, AreaNo, &Area, ID_READ);
		}
	}

	else
	{
		//Get SDK function address
		PFNIDRESINAREA pFnSetResinArea = (PFNIDRESINAREA)GetProcAddress(Parent->hLib, "ID_ResinArea");
		if (!pFnSetResinArea)
		{
			FUNCTION_NOT_ACCESSED(SetResinArea);
		}

		else
		{
			//Get the selected Resin Area settings
			ResinArea_Left.GetWindowText(temp_string);
			Area.Left = _ttoi(temp_string);
			ResinArea_Width.GetWindowText(temp_string);
			Area.Width = _ttoi(temp_string);
			ResinArea_Bottom.GetWindowText(temp_string);
			Area.Bottom = _ttoi(temp_string);
			ResinArea_Height.GetWindowText(temp_string);
			Area.Height = _ttoi(temp_string);

			//Call the SDK to write to the driver
			ID_RETURN SDKReturn = (*pFnSetResinArea)(Parent->hSession,
											         ID_WRITE,
											         Side,
											         AreaNo,
											         &Area);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetResinArea, SDKReturn);
			}

			else
			{
				//Update the message box
				ResinAreaToMsgBox(Side, AreaNo, &Area, ID_WRITE);
			}
		}
	}
}

